import * as state from './state.js';
import { raUsernameInput, raPasswordInput } from './ui.js';

export const backgroundMusic = new Audio();
export const attractMusicPlayer = new Audio();
export const navigateSound = new Audio();
export const confirmSound = new Audio();
export const cancelSound = new Audio();

let musicFadeIntervals = new Map();

export function t(key, replacements = {}) {
    let text = state.currentTranslations[key] || key;
    for (const [placeholder, value] of Object.entries(replacements)) {
        text = text.replace(`{${placeholder}}`, value);
    }
    return text;
}


export function applyTranslationsToDOM() {
    document.querySelectorAll('[data-i18n-key]').forEach(el => {
        const key = el.dataset.i18nKey;
        const translation = t(key);
        if (el.tagName === 'INPUT' || el.tagName === 'TEXTAREA') {
            if (el.placeholder) el.placeholder = translation;
        } else if (key.includes('tooltip')) {
            el.innerHTML = translation;
        } else {
            el.textContent = translation;
        }
    });
    raUsernameInput.placeholder = t('ralogin_username_placeholder');
    raPasswordInput.placeholder = t('ralogin_password_placeholder');
}

export function playSound(sound) {
    sound.currentTime = 0;
    sound.play().catch(e => console.error("Sound effect failed to play:", e));
}

export function fadeOutAndStop(audioPlayer) {
    if (musicFadeIntervals.has(audioPlayer)) {
        clearInterval(musicFadeIntervals.get(audioPlayer));
    }
    if (audioPlayer.paused || audioPlayer.volume === 0) return;

    const initialVolume = audioPlayer.volume;
    const fadeInterval = setInterval(() => {
        const newVolume = audioPlayer.volume - 0.05;
        if (newVolume <= 0) {
            audioPlayer.pause();
            audioPlayer.currentTime = 0;
            audioPlayer.volume = initialVolume;
            clearInterval(fadeInterval);
            musicFadeIntervals.delete(audioPlayer);
        } else {
            audioPlayer.volume = newVolume;
        }
    }, 25);
    musicFadeIntervals.set(audioPlayer, fadeInterval);
}

export function anyModalOpen() {
    return state.isMenuOpen || state.isLobbyOpen || state.isPowerMenuOpen ||
           state.isAudioMenuOpen || state.isDisplayMenuOpen || state.isConfigMenuOpen ||
           state.isUsernameModalOpen || state.isSaveStateModalOpen || state.isRaLoginModalOpen ||
           state.isNetworkMenuOpen;
}

export function shuffleArray(array) {
    for (let i = array.length - 1; i > 0; i--) {
        const j = Math.floor(Math.random() * (i + 1));
        [array[i], array[j]] = [array[j], array[i]];
    }
    return array;
}